IF NOT EXISTS(
  SELECT * FROM sys.tables WHERE name = 'BA_RoleDefaultPrincipals')
BEGIN
	CREATE TABLE [dbo].[BA_RoleDefaultPrincipals] (
		[DefaultForRoles_RepositoryConfigRoleId] int  NOT NULL,
		[DefaultPrincipals_PrincipalId] int  NOT NULL
	);
	
	ALTER TABLE [dbo].[BA_RoleDefaultPrincipals]
	ADD CONSTRAINT [PK_BA_RoleDefaultPrincipals]
		PRIMARY KEY CLUSTERED ([DefaultForRoles_RepositoryConfigRoleId], [DefaultPrincipals_PrincipalId] ASC);
	
	ALTER TABLE [dbo].[BA_RoleDefaultPrincipals]
	ADD CONSTRAINT [FK_BA_RoleDefaultPrincipals_BA_Role]
		FOREIGN KEY ([DefaultForRoles_RepositoryConfigRoleId])
		REFERENCES [dbo].[BA_Role]
			([RepositoryConfigRoleId])
		ON DELETE NO ACTION ON UPDATE NO ACTION;

	ALTER TABLE [dbo].[BA_RoleDefaultPrincipals]
	ADD CONSTRAINT [FK_BA_RoleDefaultPrincipals_BA_Principal]
		FOREIGN KEY ([DefaultPrincipals_PrincipalId])
		REFERENCES [dbo].[BA_Principal]
			([PrincipalId])
		ON DELETE NO ACTION ON UPDATE NO ACTION;

	CREATE INDEX [IX_FK_BA_RoleDefaultPrincipals_BA_Principal]
	ON [dbo].[BA_RoleDefaultPrincipals]
		([DefaultPrincipals_PrincipalId]);
END;